; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - Strand Scroll Data
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes
                        
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Colors               include color.asm           ; Colour RAM Address / Colours
                        
Game                    include inc\BH_Game.asm     ; Game Variables
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemStrand            ; Beach Head - Shore00.prg
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaPtr    set  *                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; 256 pointers to data for 256 screen scroll columns PosX (PosY set in the addressed structs)
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaPtrLo  set  *                      ; 
TabColPtrLo_Screen_06   set  *                      ; Screen 6 - To Next Level
                        dc.b <$0000                 ; $00
                        dc.b <Data_Screen_6_Col_01  ; $01
                        dc.b <Data_Screen_6_Col_02  ; $02
                        dc.b <Data_Screen_6_Col_03  ; $03
                        dc.b <Data_Screen_6_Col_04  ; $04
                        dc.b <$0000                 ; $05
                        dc.b <$0000                 ; $06
                        dc.b <$0000                 ; $07
                        dc.b <$0000                 ; $08
                        dc.b <$0000                 ; $09
                        dc.b <$0000                 ; $0a
                        dc.b <$0000                 ; $0b
                        dc.b <$0000                 ; $0c
                        dc.b <$0000                 ; $0d
                        dc.b <$0000                 ; $0e
                        dc.b <$0000                 ; $0f
                        
TabColPtrLo_Screen_05   set  *                      ; Screen 5 - Bridge
                        dc.b <$0000                 ; $00
                        dc.b <$0000                 ; $01
                        dc.b <$0000                 ; $02
                        dc.b <$0000                 ; $03
                        dc.b <$0000                 ; $04
                        dc.b <$0000                 ; $05
                        dc.b <Data_Screen_5_Col_06  ; $06
                        dc.b <Data_Screen_5_Col_07  ; $07
                        dc.b <$0000                 ; $08
                        dc.b <Data_Screen_5_Col_09  ; $09
                        dc.b <Data_Screen_5_Col_0a  ; $0a
                        dc.b <$0000                 ; $0b
                        dc.b <$0000                 ; $0c
                        dc.b <Data_Screen_5_Col_0d  ; $0d
                        dc.b <Data_Screen_5_Col_0e  ; $0e
                        dc.b <Data_Screen_5_Col_0f  ; $0f
                        dc.b <Data_Screen_5_Col_10  ; $10
                        dc.b <Data_Screen_5_Col_11  ; $11
                        dc.b <$0000                 ; $12
                        dc.b <Data_Screen_5_Col_13  ; $13
                        dc.b <$0000                 ; $14
                        dc.b <Data_Screen_5_Col_15  ; $15
                        dc.b <Data_Screen_5_Col_16  ; $16
                        dc.b <Data_Screen_5_Col_17  ; $17
                        dc.b <Data_Screen_5_Col_18  ; $18
                        dc.b <$0000                 ; $19
                        dc.b <Data_Screen_5_Col_1a  ; $1a
                        dc.b <$0000                 ; $1b
                        dc.b <Data_Screen_5_Col_1c  ; $1c
                        dc.b <Data_Screen_5_Col_1d  ; $1d
                        dc.b <$0000                 ; $1e
                        dc.b <Data_Screen_5_Col_1f  ; $1f
                        dc.b <Data_Screen_5_Col_20  ; $20
                        dc.b <$0000                 ; $21
                        dc.b <$0000                 ; $22
                        dc.b <Data_Screen_5_Col_23  ; $23
                        dc.b <$0000                 ; $24
                        dc.b <Data_Screen_5_Col_25  ; $25
                        dc.b <$0000                 ; $26
                        dc.b <Data_Screen_5_Col_27  ; $27
                        
TabColPtrLo_Screen_04   set  *                      ; Screen 4 - Labyrinth
                        dc.b <$0000                 ; $00
                        dc.b <$0000                 ; $01
                        dc.b <Data_Screen_4_Col_02  ; $02
                        dc.b <Data_Screen_4_Col_03  ; $03
                        dc.b <Data_Screen_4_Col_04  ; $04
                        dc.b <Data_Screen_4_Col_05  ; $05
                        dc.b <$0000                 ; $06
                        dc.b <Data_Screen_4_Col_07  ; $07
                        dc.b <Data_Screen_4_Col_08  ; $08
                        dc.b <$0000                 ; $09
                        dc.b <Data_Screen_4_Col_0a  ; $0a
                        dc.b <$0000                 ; $0b
                        dc.b <Data_Screen_4_Col_0c  ; $0c
                        dc.b <Data_Screen_4_Col_0d  ; $0d
                        dc.b <Data_Screen_4_Col_0e  ; $0e
                        dc.b <Data_Screen_4_Col_0f  ; $0f
                        dc.b <Data_Screen_4_Col_10  ; $10
                        dc.b <$0000                 ; $11
                        dc.b <Data_Screen_4_Col_12  ; $12
                        dc.b <$0000                 ; $13
                        dc.b <Data_Screen_4_Col_14  ; $14
                        dc.b <Data_Screen_4_Col_15  ; $15
                        dc.b <$0000                 ; $16
                        dc.b <Data_Screen_4_Col_17  ; $17
                        dc.b <Data_Screen_4_Col_18  ; $18
                        dc.b <$0000                 ; $19
                        dc.b <$0000                 ; $1a
                        dc.b <$0000                 ; $1b
                        dc.b <Data_Screen_4_Col_1c  ; $1c
                        dc.b <Data_Screen_4_Col_1d  ; $1d
                        dc.b <$0000                 ; $1e
                        dc.b <$0000                 ; $1f
                        dc.b <Data_Screen_4_Col_20  ; $20
                        dc.b <$0000                 ; $21
                        dc.b <Data_Screen_4_Col_22  ; $22
                        dc.b <Data_Screen_4_Col_23  ; $23
                        dc.b <$0000                 ; $24
                        dc.b <$0000                 ; $25
                        dc.b <Data_Screen_4_Col_26  ; $26
                        dc.b <Data_Screen_4_Col_27  ; $27
                        
TabColPtrLo_Screen_03   set  *                      ; Screen 3 - 
                        dc.b <Data_Screen_3_Col_00  ; $00
                        dc.b <Data_Screen_3_Col_01  ; $01
                        dc.b <$0000                 ; $02
                        dc.b <$0000                 ; $03
                        dc.b <Data_Screen_3_Col_04  ; $04
                        dc.b <Data_Screen_3_Col_05  ; $05
                        dc.b <$0000                 ; $06
                        dc.b <Data_Screen_3_Col_07  ; $07
                        dc.b <Data_Screen_3_Col_08  ; $08
                        dc.b <Data_Screen_3_Col_09  ; $09
                        dc.b <$0000                 ; $0a
                        dc.b <Data_Screen_3_Col_0b  ; $0b
                        dc.b <$0000                 ; $0c
                        dc.b <Data_Screen_3_Col_0d  ; $0d
                        dc.b <$0000                 ; $0e
                        dc.b <Data_Screen_3_Col_0f  ; $0f
                        dc.b <Data_Screen_3_Col_10  ; $10
                        dc.b <$0000                 ; $11
                        dc.b <Data_Screen_3_Col_12  ; $12
                        dc.b <Data_Screen_3_Col_13  ; $13
                        dc.b <Data_Screen_3_Col_14  ; $14
                        dc.b <$0000                 ; $15
                        dc.b <Data_Screen_3_Col_16  ; $16
                        dc.b <$0000                 ; $17
                        dc.b <Data_Screen_3_Col_18  ; $18
                        dc.b <Data_Screen_3_Col_19  ; $19
                        dc.b <$0000                 ; $1a
                        dc.b <Data_Screen_3_Col_1b  ; $1b
                        dc.b <Data_Screen_3_Col_1c  ; $1c
                        dc.b <Data_Screen_3_Col_1d  ; $1d
                        dc.b <Data_Screen_3_Col_1e  ; $1e
                        dc.b <$0000                 ; $1f
                        dc.b <Data_Screen_3_Col_20  ; $20
                        dc.b <Data_Screen_3_Col_21  ; $21
                        dc.b <Data_Screen_3_Col_22  ; $22
                        dc.b <$0000                 ; $23
                        dc.b <Data_Screen_3_Col_24  ; $24
                        dc.b <$0000                 ; $25
                        dc.b <Data_Screen_3_Col_26  ; $26
                        dc.b <Data_Screen_3_Col_27  ; $27
                        
TabColPtrLo_Screen_02   set  *                      ; Screen 2 - 
                        dc.b <Data_Screen_2_Col_00  ; $00
                        dc.b <$0000                 ; $01
                        dc.b <$0000                 ; $02
                        dc.b <Data_Screen_2_Col_03  ; $03
                        dc.b <Data_Screen_2_Col_04  ; $04
                        dc.b <$0000                 ; $05
                        dc.b <Data_Screen_2_Col_06  ; $06
                        dc.b <$0000                 ; $07
                        dc.b <$0000                 ; $08
                        dc.b <Data_Screen_2_Col_09  ; $09
                        dc.b <Data_Screen_2_Col_0a  ; $0a
                        dc.b <Data_Screen_2_Col_0b  ; $0b
                        dc.b <$0000                 ; $0c
                        dc.b <$0000                 ; $0d
                        dc.b <Data_Screen_2_Col_0e  ; $0e
                        dc.b <$0000                 ; $0f
                        dc.b <Data_Screen_2_Col_10  ; $10
                        dc.b <Data_Screen_2_Col_11  ; $11
                        dc.b <$0000                 ; $12
                        dc.b <Data_Screen_2_Col_13  ; $13
                        dc.b <Data_Screen_2_Col_14  ; $14
                        dc.b <$0000                 ; $15
                        dc.b <Data_Screen_2_Col_16  ; $16
                        dc.b <Data_Screen_2_Col_17  ; $17
                        dc.b <$0000                 ; $18
                        dc.b <Data_Screen_2_Col_19  ; $19
                        dc.b <Data_Screen_2_Col_1a  ; $1a
                        dc.b <Data_Screen_2_Col_1b  ; $1b
                        dc.b <$0000                 ; $1c
                        dc.b <Data_Screen_2_Col_1d  ; $1d
                        dc.b <$0000                 ; $1e
                        dc.b <Data_Screen_2_Col_1f  ; $1f
                        dc.b <Data_Screen_2_Col_20  ; $20
                        dc.b <$0000                 ; $21
                        dc.b <Data_Screen_2_Col_22  ; $22
                        dc.b <Data_Screen_2_Col_23  ; $23
                        dc.b <Data_Screen_2_Col_24  ; $24
                        dc.b <Data_Screen_2_Col_25  ; $25
                        dc.b <Data_Screen_2_Col_26  ; $26
                        dc.b <Data_Screen_2_Col_27  ; $27
                        
TabColPtrLo_Screen_01   set  *                      ; Screen 1 - 
                        dc.b <Data_Screen_1_Col_00  ; $00
                        dc.b <Data_Screen_1_Col_01  ; $01
                        dc.b <Data_Screen_1_Col_02  ; $02
                        dc.b <$0000                 ; $03
                        dc.b <$0000                 ; $04
                        dc.b <Data_Screen_1_Col_05  ; $05
                        dc.b <Data_Screen_1_Col_06  ; $06
                        dc.b <$0000                 ; $07
                        dc.b <Data_Screen_1_Col_08  ; $08
                        dc.b <$0000                 ; $09
                        dc.b <Data_Screen_1_Col_0a  ; $0a
                        dc.b <$0000                 ; $0b
                        dc.b <Data_Screen_1_Col_0c  ; $0c
                        dc.b <Data_Screen_1_Col_0d  ; $0d
                        dc.b <$0000                 ; $0e
                        dc.b <Data_Screen_1_Col_0f  ; $0f
                        dc.b <Data_Screen_1_Col_10  ; $10
                        dc.b <$0000                 ; $11
                        dc.b <$0000                 ; $12
                        dc.b <$0000                 ; $13
                        dc.b <Data_Screen_1_Col_14  ; $14
                        dc.b <Data_Screen_1_Col_15  ; $15
                        dc.b <$0000                 ; $16
                        dc.b <Data_Screen_1_Col_17  ; $17
                        dc.b <Data_Screen_1_Col_18  ; $18
                        dc.b <Data_Screen_1_Col_19  ; $19
                        dc.b <$0000                 ; $1a
                        dc.b <$0000                 ; $1b
                        dc.b <Data_Screen_1_Col_1c  ; $1c
                        dc.b <Data_Screen_1_Col_1d  ; $1d
                        dc.b <Data_Screen_1_Col_1e  ; $1e
                        dc.b <Data_Screen_1_Col_1f  ; $1f
                        dc.b <Data_Screen_1_Col_20  ; $20
                        dc.b <Data_Screen_1_Col_21  ; $21
                        dc.b <$0000                 ; $22
                        dc.b <Data_Screen_1_Col_23  ; $23
                        dc.b <Data_Screen_1_Col_24  ; $24
                        dc.b <Data_Screen_1_Col_25  ; $25
                        dc.b <$0000                 ; $26
                        dc.b <Data_Screen_1_Col_27  ; $27
                        
TabColPtrLo_Screen_00   set  *                      ; Screen 0 - Start
                        dc.b <$0000                 ; $00
                        dc.b <Data_Screen_0_Col_01  ; $01
                        dc.b <Data_Screen_0_Col_02  ; $02
                        dc.b <Data_Screen_0_Col_03  ; $03
                        dc.b <$0000                 ; $04
                        dc.b <Data_Screen_0_Col_05  ; $05
                        dc.b <$0000                 ; $06
                        dc.b <Data_Screen_0_Col_07  ; $07
                        dc.b <$0000                 ; $08
                        dc.b <Data_Screen_0_Col_09  ; $09
                        dc.b <Data_Screen_0_Col_0a  ; $0a
                        dc.b <Data_Screen_0_Col_0b  ; $0b
                        dc.b <$0000                 ; $0c
                        dc.b <$0000                 ; $0d
                        dc.b <Data_Screen_0_Col_0e  ; $0e
                        dc.b <Data_Screen_0_Col_0f  ; $0f
                        dc.b <Data_Screen_0_Col_10  ; $10
                        dc.b <$0000                 ; $11
                        dc.b <$0000                 ; $12
                        dc.b <$0000                 ; $13
                        dc.b <$0000                 ; $14
                        dc.b <$0000                 ; $15
                        dc.b <$0000                 ; $16
                        dc.b <$0000                 ; $17
                        dc.b <$0000                 ; $18
                        dc.b <$0000                 ; $19
                        dc.b <$0000                 ; $1a
                        dc.b <$0000                 ; $1b
                        dc.b <Data_Screen_0_Col_1c  ; $1c
                        dc.b <Data_Screen_0_Col_1d  ; $1d
                        dc.b <Data_Screen_0_Col_1e  ; $1e
                        dc.b <Data_Screen_0_Col_1f  ; $1f
                        dc.b <Data_Screen_0_Col_20  ; $20
                        dc.b <Data_Screen_0_Col_21  ; $21
                        dc.b <Data_Screen_0_Col_22  ; $22
                        dc.b <Data_Screen_0_Col_23  ; $23
                        dc.b <Data_Screen_0_Col_24  ; $24
                        dc.b <Data_Screen_0_Col_25  ; $25
                        dc.b <Data_Screen_0_Col_26  ; $26
                        dc.b <Data_Screen_0_Col_27  ; $27
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaPtrHi  set  *                      ; 
TabColPtrHi_Screen_06   set  *                      ; Screen 6 - To Next Level
                        dc.b >$0000                 ; $00
                        dc.b >Data_Screen_6_Col_01  ; $01
                        dc.b >Data_Screen_6_Col_02  ; $02
                        dc.b >Data_Screen_6_Col_03  ; $03
                        dc.b >Data_Screen_6_Col_04  ; $04
                        dc.b >$0000                 ; $05
                        dc.b >$0000                 ; $06
                        dc.b >$0000                 ; $07
                        dc.b >$0000                 ; $08
                        dc.b >$0000                 ; $09
                        dc.b >$0000                 ; $0a
                        dc.b >$0000                 ; $0b
                        dc.b >$0000                 ; $0c
                        dc.b >$0000                 ; $0d
                        dc.b >$0000                 ; $0e
                        dc.b >$0000                 ; $0f
                        
TabColPtrHi_Screen_05   set  *                      ; Screen 5 - Bridge
                        dc.b >$0000                 ; $00
                        dc.b >$0000                 ; $01
                        dc.b >$0000                 ; $02
                        dc.b >$0000                 ; $03
                        dc.b >$0000                 ; $04
                        dc.b >$0000                 ; $05
                        dc.b >Data_Screen_5_Col_06  ; $06
                        dc.b >Data_Screen_5_Col_07  ; $07
                        dc.b >$0000                 ; $08
                        dc.b >Data_Screen_5_Col_09  ; $09
                        dc.b >Data_Screen_5_Col_0a  ; $0a
                        dc.b >$0000                 ; $0b
                        dc.b >$0000                 ; $0c
                        dc.b >Data_Screen_5_Col_0d  ; $0d
                        dc.b >Data_Screen_5_Col_0e  ; $0e
                        dc.b >Data_Screen_5_Col_0f  ; $0f
                        dc.b >Data_Screen_5_Col_10  ; $10
                        dc.b >Data_Screen_5_Col_11  ; $11
                        dc.b >$0000                 ; $12
                        dc.b >Data_Screen_5_Col_13  ; $13
                        dc.b >$0000                 ; $14
                        dc.b >Data_Screen_5_Col_15  ; $15
                        dc.b >Data_Screen_5_Col_16  ; $16
                        dc.b >Data_Screen_5_Col_17  ; $17
                        dc.b >Data_Screen_5_Col_18  ; $18
                        dc.b >$0000                 ; $19
                        dc.b >Data_Screen_5_Col_1a  ; $1a
                        dc.b >$0000                 ; $1b
                        dc.b >Data_Screen_5_Col_1c  ; $1c
                        dc.b >Data_Screen_5_Col_1d  ; $1d
                        dc.b >$0000                 ; $1e
                        dc.b >Data_Screen_5_Col_1f  ; $1f
                        dc.b >Data_Screen_5_Col_20  ; $20
                        dc.b >$0000                 ; $21
                        dc.b >$0000                 ; $22
                        dc.b >Data_Screen_5_Col_23  ; $23
                        dc.b >$0000                 ; $24
                        dc.b >Data_Screen_5_Col_25  ; $25
                        dc.b >$0000                 ; $26
                        dc.b >Data_Screen_5_Col_27  ; $27
                        
TabColPtrHi_Screen_04   set  *                      ; Screen 4 - Labyrinth
                        dc.b >$0000                 ; $00
                        dc.b >$0000                 ; $01
                        dc.b >Data_Screen_4_Col_02  ; $02
                        dc.b >Data_Screen_4_Col_03  ; $03
                        dc.b >Data_Screen_4_Col_04  ; $04
                        dc.b >Data_Screen_4_Col_05  ; $05
                        dc.b >$0000                 ; $06
                        dc.b >Data_Screen_4_Col_07  ; $07
                        dc.b >Data_Screen_4_Col_08  ; $08
                        dc.b >$0000                 ; $09
                        dc.b >Data_Screen_4_Col_0a  ; $0a
                        dc.b >$0000                 ; $0b
                        dc.b >Data_Screen_4_Col_0c  ; $0c
                        dc.b >Data_Screen_4_Col_0d  ; $0d
                        dc.b >Data_Screen_4_Col_0e  ; $0e
                        dc.b >Data_Screen_4_Col_0f  ; $0f
                        dc.b >Data_Screen_4_Col_10  ; $10
                        dc.b >$0000                 ; $11
                        dc.b >Data_Screen_4_Col_12  ; $12
                        dc.b >$0000                 ; $13
                        dc.b >Data_Screen_4_Col_14  ; $14
                        dc.b >Data_Screen_4_Col_15  ; $15
                        dc.b >$0000                 ; $16
                        dc.b >Data_Screen_4_Col_17  ; $17
                        dc.b >Data_Screen_4_Col_18  ; $18
                        dc.b >$0000                 ; $19
                        dc.b >$0000                 ; $1a
                        dc.b >$0000                 ; $1b
                        dc.b >Data_Screen_4_Col_1c  ; $1c
                        dc.b >Data_Screen_4_Col_1d  ; $1d
                        dc.b >$0000                 ; $1e
                        dc.b >$0000                 ; $1f
                        dc.b >Data_Screen_4_Col_20  ; $20
                        dc.b >$0000                 ; $21
                        dc.b >Data_Screen_4_Col_22  ; $22
                        dc.b >Data_Screen_4_Col_23  ; $23
                        dc.b >$0000                 ; $24
                        dc.b >$0000                 ; $25
                        dc.b >Data_Screen_4_Col_26  ; $26
                        dc.b >Data_Screen_4_Col_27  ; $27
                        
TabColPtrHi_Screen_03   set  *                      ; Screen 3 - 
                        dc.b >Data_Screen_3_Col_00  ; $00
                        dc.b >Data_Screen_3_Col_01  ; $01
                        dc.b >$0000                 ; $02
                        dc.b >$0000                 ; $03
                        dc.b >Data_Screen_3_Col_04  ; $04
                        dc.b >Data_Screen_3_Col_05  ; $05
                        dc.b >$0000                 ; $06
                        dc.b >Data_Screen_3_Col_07  ; $07
                        dc.b >Data_Screen_3_Col_08  ; $08
                        dc.b >Data_Screen_3_Col_09  ; $09
                        dc.b >$0000                 ; $0a
                        dc.b >Data_Screen_3_Col_0b  ; $0b
                        dc.b >$0000                 ; $0c
                        dc.b >Data_Screen_3_Col_0d  ; $0d
                        dc.b >$0000                 ; $0e
                        dc.b >Data_Screen_3_Col_0f  ; $0f
                        dc.b >Data_Screen_3_Col_10  ; $10
                        dc.b >$0000                 ; $11
                        dc.b >Data_Screen_3_Col_12  ; $12
                        dc.b >Data_Screen_3_Col_13  ; $13
                        dc.b >Data_Screen_3_Col_14  ; $14
                        dc.b >$0000                 ; $15
                        dc.b >Data_Screen_3_Col_16  ; $16
                        dc.b >$0000                 ; $17
                        dc.b >Data_Screen_3_Col_18  ; $18
                        dc.b >Data_Screen_3_Col_19  ; $19
                        dc.b >$0000                 ; $1a
                        dc.b >Data_Screen_3_Col_1b  ; $1b
                        dc.b >Data_Screen_3_Col_1c  ; $1c
                        dc.b >Data_Screen_3_Col_1d  ; $1d
                        dc.b >Data_Screen_3_Col_1e  ; $1e
                        dc.b >$0000                 ; $1f
                        dc.b >Data_Screen_3_Col_20  ; $20
                        dc.b >Data_Screen_3_Col_21  ; $21
                        dc.b >Data_Screen_3_Col_22  ; $22
                        dc.b >$0000                 ; $23
                        dc.b >Data_Screen_3_Col_24  ; $24
                        dc.b >$0000                 ; $25
                        dc.b >Data_Screen_3_Col_26  ; $26
                        dc.b >Data_Screen_3_Col_27  ; $27
                        
TabColPtrHi_Screen_02   set  *                      ; Screen 2 - 
                        dc.b >Data_Screen_2_Col_00  ; $00
                        dc.b >$0000                 ; $01
                        dc.b >$0000                 ; $02
                        dc.b >Data_Screen_2_Col_03  ; $03
                        dc.b >Data_Screen_2_Col_04  ; $04
                        dc.b >$0000                 ; $05
                        dc.b >Data_Screen_2_Col_06  ; $06
                        dc.b >$0000                 ; $07
                        dc.b >$0000                 ; $08
                        dc.b >Data_Screen_2_Col_09  ; $09
                        dc.b >Data_Screen_2_Col_0a  ; $0a
                        dc.b >Data_Screen_2_Col_0b  ; $0b
                        dc.b >$0000                 ; $0c
                        dc.b >$0000                 ; $0d
                        dc.b >Data_Screen_2_Col_0e  ; $0e
                        dc.b >$0000                 ; $0f
                        dc.b >Data_Screen_2_Col_10  ; $10
                        dc.b >Data_Screen_2_Col_11  ; $11
                        dc.b >$0000                 ; $12
                        dc.b >Data_Screen_2_Col_13  ; $13
                        dc.b >Data_Screen_2_Col_14  ; $14
                        dc.b >$0000                 ; $15
                        dc.b >Data_Screen_2_Col_16  ; $16
                        dc.b >Data_Screen_2_Col_17  ; $17
                        dc.b >$0000                 ; $18
                        dc.b >Data_Screen_2_Col_19  ; $19
                        dc.b >Data_Screen_2_Col_1a  ; $1a
                        dc.b >Data_Screen_2_Col_1b  ; $1b
                        dc.b >$0000                 ; $1c
                        dc.b >Data_Screen_2_Col_1d  ; $1d
                        dc.b >$0000                 ; $1e
                        dc.b >Data_Screen_2_Col_1f  ; $1f
                        dc.b >Data_Screen_2_Col_20  ; $20
                        dc.b >$0000                 ; $21
                        dc.b >Data_Screen_2_Col_22  ; $22
                        dc.b >Data_Screen_2_Col_23  ; $23
                        dc.b >Data_Screen_2_Col_24  ; $24
                        dc.b >Data_Screen_2_Col_25  ; $25
                        dc.b >Data_Screen_2_Col_26  ; $26
                        dc.b >Data_Screen_2_Col_27  ; $27
                        
TabColPtrHi_Screen_01   set  *                      ; Screen 1 - 
                        dc.b >Data_Screen_1_Col_00  ; $00
                        dc.b >Data_Screen_1_Col_01  ; $01
                        dc.b >Data_Screen_1_Col_02  ; $02
                        dc.b >$0000                 ; $03
                        dc.b >$0000                 ; $04
                        dc.b >Data_Screen_1_Col_05  ; $05
                        dc.b >Data_Screen_1_Col_06  ; $06
                        dc.b >$0000                 ; $07
                        dc.b >Data_Screen_1_Col_08  ; $08
                        dc.b >$0000                 ; $09
                        dc.b >Data_Screen_1_Col_0a  ; $0a
                        dc.b >$0000                 ; $0b
                        dc.b >Data_Screen_1_Col_0c  ; $0c
                        dc.b >Data_Screen_1_Col_0d  ; $0d
                        dc.b >$0000                 ; $0e
                        dc.b >Data_Screen_1_Col_0f  ; $0f
                        dc.b >Data_Screen_1_Col_10  ; $10
                        dc.b >$0000                 ; $11
                        dc.b >$0000                 ; $12
                        dc.b >$0000                 ; $13
                        dc.b >Data_Screen_1_Col_14  ; $14
                        dc.b >Data_Screen_1_Col_15  ; $15
                        dc.b >$0000                 ; $16
                        dc.b >Data_Screen_1_Col_17  ; $17
                        dc.b >Data_Screen_1_Col_18  ; $18
                        dc.b >Data_Screen_1_Col_19  ; $19
                        dc.b >$0000                 ; $1a
                        dc.b >$0000                 ; $1b
                        dc.b >Data_Screen_1_Col_1c  ; $1c
                        dc.b >Data_Screen_1_Col_1d  ; $1d
                        dc.b >Data_Screen_1_Col_1e  ; $1e
                        dc.b >Data_Screen_1_Col_1f  ; $1f
                        dc.b >Data_Screen_1_Col_20  ; $20
                        dc.b >Data_Screen_1_Col_21  ; $21
                        dc.b >$0000                 ; $22
                        dc.b >Data_Screen_1_Col_23  ; $23
                        dc.b >Data_Screen_1_Col_24  ; $24
                        dc.b >Data_Screen_1_Col_25  ; $25
                        dc.b >$0000                 ; $26
                        dc.b >Data_Screen_1_Col_27  ; $27
                        
TabColPtrHi_Screen_00   set  *                      ; Screen 0 - Start
                        dc.b >$0000                 ; $00
                        dc.b >Data_Screen_0_Col_01  ; $01
                        dc.b >Data_Screen_0_Col_02  ; $02
                        dc.b >Data_Screen_0_Col_03  ; $03
                        dc.b >$0000                 ; $04
                        dc.b >Data_Screen_0_Col_05  ; $05
                        dc.b >$0000                 ; $06
                        dc.b >Data_Screen_0_Col_07  ; $07
                        dc.b >$0000                 ; $08
                        dc.b >Data_Screen_0_Col_09  ; $09
                        dc.b >Data_Screen_0_Col_0a  ; $0a
                        dc.b >Data_Screen_0_Col_0b  ; $0b
                        dc.b >$0000                 ; $0c
                        dc.b >$0000                 ; $0d
                        dc.b >Data_Screen_0_Col_0e  ; $0e
                        dc.b >Data_Screen_0_Col_0f  ; $0f
                        dc.b >Data_Screen_0_Col_10  ; $10
                        dc.b >$0000                 ; $11
                        dc.b >$0000                 ; $12
                        dc.b >$0000                 ; $13
                        dc.b >$0000                 ; $14
                        dc.b >$0000                 ; $15
                        dc.b >$0000                 ; $16
                        dc.b >$0000                 ; $17
                        dc.b >$0000                 ; $18
                        dc.b >$0000                 ; $19
                        dc.b >$0000                 ; $1a
                        dc.b >$0000                 ; $1b
                        dc.b >Data_Screen_0_Col_1c  ; $1c
                        dc.b >Data_Screen_0_Col_1d  ; $1d
                        dc.b >Data_Screen_0_Col_1e  ; $1e
                        dc.b >Data_Screen_0_Col_1f  ; $1f
                        dc.b >Data_Screen_0_Col_20  ; $20
                        dc.b >Data_Screen_0_Col_21  ; $21
                        dc.b >Data_Screen_0_Col_22  ; $22
                        dc.b >Data_Screen_0_Col_23  ; $23
                        dc.b >Data_Screen_0_Col_24  ; $24
                        dc.b >Data_Screen_0_Col_25  ; $25
                        dc.b >Data_Screen_0_Col_26  ; $26
                        dc.b >Data_Screen_0_Col_27  ; $27
; -------------------------------------------------------------------------------------------------------------- ;
; Enemy sprite start positions - .hbu016.
; -------------------------------------------------------------------------------------------------------------- ;
TabEnemySpritePos       set  *   ;
TabBeachPosCannon       set  *   ; 
                        dc.b $d7 ; PosX of TabScrnTankScrollPos
                        dc.b $a3 ; PosY (row * 8) + 33 + 10
                        dc.b $a9 ; PosX of TabScrnTankScrollPos
                        dc.b $73 ; PosY (row * 8) + 33 + 10
                        dc.b $7d ; PosX of TabScrnTankScrollPos
                        dc.b $bb ; PosY (row * 8) + 33 + 10
                        dc.b $52 ; PosX of TabScrnTankScrollPos
                        dc.b $73 ; PosY (row * 8) + 33 + 10
                        dc.b $14 ; PosX of TabScrnTankScrollPos
                        dc.b $a3 ; PosY (row * 8) + 33 + 10
                          
                        dc.b $00 ; EndOfTable
                        dc.b $00 ; 
                          
TabBeachPosTank         set  *   ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                          
                        dc.b $00 ; EndOfTable
                        dc.b $00 ; 
                          
TabBeachPosGunner       set  *   ; 
                        dc.b $29 ; PosX of TabScrnTankScrollPos
                        dc.b $8b ; PosY (row * 8) + 33 + 10
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                          
                        dc.b $00 ; EndOfTable
                        dc.b $00 ; 
                          
TabBeachPosTurret       set  *   ; 
                        dc.b $42 ; PosX of TabScrnTankScrollPos
                        dc.b $b3 ; PosY (row * 8) + 33 + 10
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                        dc.b $00 ; not defined
                        dc.b $00 ; 
                          
                        dc.b $00 ; EndOfTable
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaData   set  *   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_6_Col_01    set  *   ; 
                        dc.b $0a ; 
                        dc.b $7a ; 
                        dc.b RED ; 
                        
                        dc.b $0b ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0c ; 
                        dc.b $80 ; 
                        dc.b RED ; 
                        
                        dc.b $0d ; 
                        dc.b $c1 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $0e ; 
                        dc.b $c2 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $0f ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $11 ; 
                        dc.b $85 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_6_Col_02    set  *   ; 
                        dc.b $0b ; 
                        dc.b $7c ; 
                        dc.b RED ; 
                        
                        dc.b $0c ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0d ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $0f ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $83 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_6_Col_03    set  *   ; 
                        dc.b $0c ; 
                        dc.b $7d ; 
                        dc.b RED ; 
                        
                        dc.b $0d ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $80 ; 
                        dc.b RED ; 
                        
                        dc.b $0f ; 
                        dc.b $82 ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $84 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_6_Col_04    set  *   ; 
                        dc.b $0d ; 
                        dc.b $7f ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $81 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_06    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_07    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_09    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_0a    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_0d    set  *   ; 
                        dc.b $11 ; 
                        dc.b $b2 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b6 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_0e    set  *   ; 
                        dc.b $08 ; 
                        dc.b $6c ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6e ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $70 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $72 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $74 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $79 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $ae ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $11 ; 
                        dc.b $b3 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $b9 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_0f    set  *   ; 
                        dc.b $08 ; 
                        dc.b $6d ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6f ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $71 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $73 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $77 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $b4 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $10 ; 
                        dc.b $af ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $11 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $75 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_10    set  *   ; 
                        dc.b $0c ; 
                        dc.b $76 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ac ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $10 ; 
                        dc.b $b0 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $11 ; 
                        dc.b $b5 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b8 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $ba ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_11    set  *   ; 
                        dc.b $0d ; 
                        dc.b $78 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ad ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $10 ; 
                        dc.b $b1 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ; 
                        
                        dc.b $13 ; 
                        dc.b $bb ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_13    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_15    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_16    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_17    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_18    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $16 ; 
                        dc.b $16 ;  ; 
                        dc.b $16 ;  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_1a    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_1c    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_1d    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_1f    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_20    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_23    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_25    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_5_Col_27    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_02    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_03    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_04    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_05    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_07    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_08    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $15 ; 
                        dc.b $11 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_0a    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $15 ; 
                        dc.b $11 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_0c    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_0d    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_0e    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_0f    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_10    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_12    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_14    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_15    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_17    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_18    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_1c    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_1d    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_20    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_22    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_23    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_26    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_4_Col_27    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_00    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_01    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_04    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_05    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_07    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_08    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_09    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_0b    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_0d    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_0f    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_10    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_12    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_13    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_14    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_16    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_18    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_19    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_1b    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $15 ; 
                        dc.b $11 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_1c    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $15 ; 
                        dc.b $11 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_1d    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $15 ; 
                        dc.b $11 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_1e    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_20    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_21    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_22    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_24    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_26    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_3_Col_27    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_00    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_03    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_04    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_06    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_09    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_0a    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_0b    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_0e    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_10    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_11    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_13    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_14    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_16    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_17    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_19    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_1a    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_1b    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_1d    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_1f    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_20    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_22    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_23    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_24    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_25    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_26    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_2_Col_27    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_00    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_01    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_02    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_05    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_06    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_08    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_0a    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_0c    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_0d    set  *   ; 
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_0f    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_10    set  *   ; 
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_14    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_15    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_17    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_18    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_19    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_1c    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_1d    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_1e    set  *   ; 
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_1f    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_20    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_21    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_23    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_24    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_25    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $16 ; 
                        dc.b $16 ;  ; 
                        dc.b $16 ;  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_1_Col_27    set  *   ; 
                        dc.b $0b ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_01    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_02    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_03    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_05    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_07    set  *   ; 
                        dc.b $11 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_09    set  *   ; 
                        dc.b $0d ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_0a    set  *   ; 
                        dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_0b    set  *   ; 
                        dc.b $0a ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_0e    set  *   ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_0f    set  *   ; 
                        dc.b $09 ; 
                        dc.b $48 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Struct:                        ; 1st = ColumnNo - Min=$09 / Max=$13
;                                ; 2nd = Char Num - Of ScreenDataBayShore
;                                ; 3rd = ColorRAM - End of Struct: Bit 7=1 
; -------------------------------------------------------------------------------------------------------------- ;
Data_Screen_0_Col_10    set  *   ; 
                        dc.b $0f ; 
                        dc.b $48 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
IncFixScrn0             include inc\BH_StrandShore.asm ; Include for Screen 0 - Fix Part
; -------------------------------------------------------------------------------------------------------------- ;
